$Ontext
The code solves the problem for a single TMDL (not the whole range) to get the
detail data on each problem solution when trading is available.
The health care cost is considered as a part of the objective function and TMDL
is taken as a decision variable.

$offtext

$Offlisting
$Offsymxref
$Offsymlist
$Offuelxref
$Offuellist
$Offupper

$Offdigit

options Limcol=0;
options Limrow=0;
options profile=0;
option sysout=off;
option solprint=off;

Sets i Number of industries /1*29/
     j Number of treatment options /1*3/
     alias(i,k);

Parameter TMDL /32/
         HSC Highest Segment Concentration (ng per lit) /5.0/
         CAL Current Annual Load (Kilograms per year) /58.8/

         r trading ratio /1.1/
         F trading transaction cost (dollars per Kg) /400000000/

         TC Plant costs for the three technologies /1 1.0,2 1.55,3 0.65/
         q Reductions possible by the treatment technologies /1 2,2 3,3 1/

         water_intake Intake of water by an average individual per day in liters /2.0/
         fish_intake Intake of fish food by an everage individual in kg per day /0.0175/
         safe_hg Safe concentration of Hg in fishes in mg per kg /0.4/
         LC50 The LC50 value of HG (taken from fishes) in micrograms per liter /350/

         Compensation Compensation for each dead person in dollar /3000000/
         w_health The weighting coefficient on health care cost /1/
         population total population consuming the water /10000/;


Table Data Date related to the industries
*Data(i,1) is the total volumetric discharge in MGD
*Data(i,2) is the current discharge concentration in nanograms/liter
*Data(i,3) is the available capital with the industry in Million Dollars
         1       2       3
1        46.1    4.65    68
2        1.5     3.7     8
3        4.6     4.3     15
4        1.5     3.4     5
5        2       3.88    10
6        2.24    3.7     12
7        1.2     3.9     9
8        27      4.83    30
9        4.5     4.0     15
10       1       3.1     5
11       1       3.06    5
12       1       3.22    5
13       2       3.31    9
14       3.765   4.8     10
15       18      4.33    60
16       7.2     5.1     20
17       58.6    4.87    100
18       23      4.52    40
19       1.152   5.05    10
20       0.362   4.14    5
21       108     4.58    130
22       4.68    5.2     12
23       28.09   4.41    45
24       1.921   3.9     10
25       0.544   4.5     7
26       0.5     3.95    10
27       0.003   3.72    5
28       1.246   4.1     5
29       0.054   3.4     3;


scalar k1 conversion from gallons to liters /3.7845/
       k2 scalar used as a couter;

Parameter cost cost incurred by each industry due to waste treatment setup
         cost_total The total overall cost incurred which is to be minimized
         cost_combined Combined cost including the technology cost and health care cost
         cost_health The actual health cost incurred due to the pollutant discharge
         target_reduction The total reduction from all the industries targetted
         red_total The final combined reduction from the industries
         WQS Water quality standard at a particular TMDL
         reduction The individual reductions to be achieved at a particular TMDL

         Results To store the results

         Tech_cost cost incurred by each industry due to waste treatment setup
         Tech_cost_total The total overall cost incurred which is to be minimized;

Parameter v
          u;

binary variables b binary variable specifying the process selection;

variable t Variable deciding the amount of mercury traded between various industries
         Tobj Objective function
         obj Objective function
         red_final
         WQS_final
         WQS_avg
         mortality;


WQS = (HSC/CAL)*TMDL;
reduction(i,'1')=(Data(i,'2')-WQS)*Data(i,'1')*k1*10**(-6)*365;

*===============================================================================
* First solving the Technology only model to generate constraints for the problem
* The constraint states that no industry should be required to spend more as a results
* of trading.

* Definig the Technology only problem
Equations Tobjective
         Tc1
         Tc2
         Tc3
         Tc4
         Tc5
         Tc6
         Tc7;

Tobjective.. Tobj =e=1000*365*sum((i,j),TC(j)*Data(i,'1')*b(i,j))+w_health*mortality*compensation;
Tc1(i)..  sum(j,b(i,j)) =l= 3;
Tc2(i).. red_final(i,'1')=e=10**(-6)*k1*365*sum(j,q(j)*Data(i,'1')*b(i,j));
Tc3(i).. red_final(i,'1')=g= reduction(i,'1');
Tc4(i).. red_final(i,'1')=g= 0;
Tc5(i).. WQS_final(i,'1')=e=Data(i,'2')-red_final(i,'1')/(Data(i,'1')*k1*10**(-6)*365);
Tc6.. WQS_avg=e=sum(i,WQS_final(i,'1')*(Data(i,'1')*k1*10**(-6)*365))/sum(i,(Data(i,'1')*k1*10**(-6)*365));
Tc7.. mortality=e=((WQS_avg*safe_hg/2.8)*fish_intake*1000*0.5*population/(LC50*water_intake));
mortality.lo=0;
WQS_final.lo(i,'1')=0;

model Tech_problem /Tobjective,Tc1, Tc2, Tc3, Tc4, Tc5, Tc6, Tc7/;

*===============================================================================
Equations objective
         c1
         c2
         c3
         c4
         c5
         c6
         c7
         c8
         c9;

objective.. obj =e= 1000*365*sum((i,j),TC(j)*Data(i,'1')*b(i,j))+w_health*mortality*compensation;

c1(i).. t(i,i) =e= 0;
c2(i).. red_final(i,'1')=e=10**(-6)*k1*365*sum(j,q(j)*Data(i,'1')*b(i,j))+sum(k,t(i,k))-r*sum(k,t(k,i));
c3(i).. red_final(i,'1')=g= reduction(i,'1');
c4(i).. red_final(i,'1')=g= 0;
c5(i).. WQS_final(i,'1')=e=Data(i,'2')-red_final(i,'1')/(Data(i,'1')*k1*10**(-6)*365);
c6.. WQS_avg=e=sum(i,WQS_final(i,'1')*(Data(i,'1')*k1*10**(-6)*365))/sum(i,(Data(i,'1')*k1*10**(-6)*365));
c7.. mortality=e=((WQS_avg*safe_hg/2.8)*fish_intake*1000*0.5*population/(LC50*water_intake));
c8(i).. Tech_cost(i) =g= 1000*365*sum(j,b(i,j)*Data(i,'1')*TC(j))+F*(sum(k,t(i,k))-sum(k,t(k,i)))/1000;
c9(i)..  sum(j,b(i,j)) =l= 3;

t.lo(i,k) = 0;
mortality.lo=0;
WQS_final.lo(i,'1')=0;

model problem /objective, c1, c2, c3, c4, c5, c6, c7, c8, c9/;

*=== Solving the Technology only problem to generate constraint for the main problem===
option Optcr=0.001;
solve Tech_problem using mip minimizing Tobj;
u(i,j)=b.l(i,j);
Tech_cost(i)=1000*365*sum(j,b.l(i,j)*Data(i,'1')*TC(j));
Tech_cost_total=sum(i,Tech_cost(i));
*===============================================================================

option Optcr=0.001;
solve problem using mip minimizing obj;

cost_health=mortality.l*compensation;
target_reduction=sum(i,reduction(i,'1'));

*===============================================================================
red_total=sum(i,red_final.l(i,'1'));

cost(i,'1')=1000*365*sum(j,b.l(i,j)*Data(i,'1')*TC(j))+F*(sum(k,t.l(i,k))-sum(k,t.l(k,i)))/1000;
cost_total=sum(i,cost(i,'1'));
*===============================================================================

v=sum((i,k), t.l(i,k));

Results('1','1')=red_total;
Results('1','2')=cost_health;
Results('1','3')=cost_total;
Results('1','4')=obj.l;
Results('1','5')=v;

display b.l,red_final.l, Results;
